# YouTube Gallery

A Drupal module that retrieves and displays all videos from a specified
YouTube channel on your website.

## Getting Started

### 1. Configure the Module

Navigate to:\
**Administration → Configuration → Web Services → YouTube Gallery**

### 2. Add API Credentials

Under the configuration tab, enter: - **Google API Key** - **YouTube
Channel ID** - **Maximum number of videos** to retrieve

### 3. Channel Status Overview

On the *Manage Display* page, the following information is shown: -
Total number of videos detected - Configured values (API key, channel
ID, etc.) - Retrieved channel name

### 4. Place the Block

Add the **YouTube Gallery** block to any region using the Block Layout
UI.

### 5. Done!

## Overriding the Template

To customize output:

Copy the module template:\
`modules/youtube_gallery/templates/youtube-gallery.html.twig`

Paste it into your theme's template directory.\
The Twig template includes doc comments describing all available
variables.

## 👤 Previous maintainers

-   **cmsMinds:** https://www.drupal.org/cmsminds

## 👤 Current maintainers

-   **Entreprise 7pro.ca Inc:** https://www.drupal.org/entreprise-7proca-inc
-   **Project Page:** https://www.drupal.org/project/youtube_gallery

## Upload Functionality (Optional)

If using the upload feature, ensure your Google Console OAuth client
includes the following **Authorized Redirect URI**:

    https://www.yourhost.com/admin/config/youtube_gallery/upload-video
