<?php

namespace Drupal\youtube_latest_block\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Youtube settings for this site.
 */
class YoutubeLatestSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'youtube_latest_block_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['youtube_latest_block.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->configFactory->get('youtube_latest_block.settings');
    $form['text'] = [
      '#type' => 'markup',
      '#markup' => '<p>' . $this->t('Sign up and create a project at <a href="https://console.cloud.google.com" target="_blank">Google Cloud</a>, got to API\'s and Services, click the enable API\'s and services button, enable YouTube Data API v3. Follow the directions to <a href="https://www.youtube.com/watch?v=Bzw2T18YDJ4&t=380s" target="_blank">Get API Key</a> Take the key you get and save the key here.') . '</p>',
    ];
    $form['youtube_latest_block'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('API Configuration'),
    ];
    $form['youtube_latest_block']['youtube_latest_block_api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('YouTube Api Key'),
      '#description' => $this->t('Save your Google Youtube API key here.'),
      '#default_value' => $config->get('youtube_latest_block_api_key'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $values = $form_state->getValues();
    $this->configFactory->getEditable('youtube_latest_block.settings')
      ->set('youtube_latest_block_api_key', $values['youtube_latest_block_api_key'])
      ->save();

    parent::submitForm($form, $form_state);
  }

}
