# YouTube Playlists Module

This module allows you to fetch YouTube playlists from a YouTube channel and create nodes of type "YouTube Playlists". It also provides a view page at the URI `/youtube-playlists` for displaying the playlists.

## How to Use

1. **Install the Module**  
    Install the YouTube Playlists module as you would normally install any other Drupal module.

2.  Add Youtube API Key and Youtube Channel Id in the form page "/admin/config/youtube-playlists-settings"

3. **Create a "YouTube Playlists" Content Type**  
   Add content of type "YouTube Playlists" by providing the "Title" and "Playlist YouTube Link" fields, and save the content.

4. **Run Drupal Cron**  
   Execute Drupal Cron to fetch data from the YouTube channel based on the provided playlist link.

5. **View Your Playlists**  
   Navigate to the page `/youtube-playlists` to see the fetched playlists.

6. **Create Custom Views**  
   You can create custom views for the "YouTube Playlists" content type to suit your needs.

## Notes

- You must manually add content of type "YouTube Playlists" with the "Title" and "Playlist YouTube Link" fields filled in.
- When Drupal Cron runs, it will sync the playlist data from the YouTube API to your Drupal site.