<?php

namespace Drupal\youtube_playlists\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * {@inheritdoc}
 */
class YoutubePlaylistsSettingsForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'youtube_playlists_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $state = \Drupal::state();
    $youtube_api_key = $state->get('youtube_playlists.youtube_api_key');
    $youtube_channel_id = $state->get('youtube_playlists.youtube_channel_id');

    $form['youtube_api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Youtube API Key'),
      '#default_value' => $youtube_api_key,
      '#description' => t('Enter youtube API key.'),
      '#size' => 60,

    ];
    $form['youtube_channel_id'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Youtube Channel Id'),
      '#default_value' => $youtube_channel_id,
      '#description' => t('Enter Youtube Channel Id.'),
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $state = \Drupal::state();
    $state->set('youtube_playlists.youtube_api_key', $form_state->getValue('youtube_api_key'));
    $state->set('youtube_playlists.youtube_channel_id', $form_state->getValue('youtube_channel_id'));

    \Drupal::messenger()->addMessage($this->t('Settings Saved Successfully.'));
  }

}
