<?php

/**
 * @file
 * YUSA OpenY YMCA360 integration content migrations.
 */

/**
 * Resets hashes to force data sync.
 */
function yusaopeny_ymca360_post_update_reset_hashes_001(): void {
  \Drupal::service('yusaopeny_ymca360.mapping_repository')->resetHashes();
}

/**
 * Sets default registration link title for existing installations.
 */
function yusaopeny_ymca360_post_update_set_default_reservation_text_002(): void {
  $config = \Drupal::configFactory()->getEditable('yusaopeny_ymca360.settings');

  if ($config->get('reservation_text') === NULL) {
    $config
      ->set('reservation_text', 'REGISTER')
      ->save();
  }
}
