<?php

namespace Drupal\zenwidgets\Form;

use Drupal\Core\Config\Config;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Config\TypedConfigManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class ZenWidgetsConfigForm extends ConfigFormBase {

  protected Config $config;

  public function __construct(
    ConfigFactoryInterface $config_factory,
    protected TypedConfigManagerInterface $typedConfigManager,
  ) {
    parent::__construct($config_factory, $this->typedConfigManager);
    $this->config = $this->config('zenwidgets.config');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'zenwidgets_config';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'zenwidgets.config',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $form['website_id'] = [
      '#title' => 'Website ID',
      '#type' => 'textfield',
      '#description' => $this->t('Go to <a href="https://www.zenwidgets.com">zenwidgets.com</a> to register for an account to get your website ID and authentication token.'),
      '#required' => TRUE,
      '#default_value' => $this->config->get('website_id'),
    ];
    $form['authentication_token'] = [
      '#title' => 'Authentication token',
      '#type' => 'textfield',
      '#required' => TRUE,
      '#default_value' => $this->config->get('authentication_token'),
    ];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('zenwidgets.config')
      ->set('website_id', $form_state->getValue('website_id'))
      ->set('authentication_token', $form_state->getValue('authentication_token'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
