<?php

namespace Drupal\zenwidgets\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

#[FieldFormatter(
  id: 'zenwidgets_widget_default_formatter',
  label: new TranslatableMarkup('Widget default formatter'),
  field_types: [
    'zenwidgets_widget',
  ],
)]
class WidgetDefaultFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    $summary = [];

    $summary[] = var_export($this->getSettings(), TRUE);

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    /** @var \Drupal\zenwidgets\Service\ZenWidgetsService $widgetService */
    $widgetService = \Drupal::service('zenwidgets');

    foreach ($items as $delta => $item) {

      $elements[$delta] = [
        $widgetService->getWidgetRenderArray($item->value, $item->instance_data),
      ];
    }

    return $elements;
  }

}
