<?php

namespace Drupal\zenwidgets\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\DataDefinition;

#[FieldType(
  id: "zenwidgets_widget",
  label: new TranslatableMarkup("ZEN widget"),
  description: new TranslatableMarkup("A widget from zenwidgets.com."),
  default_widget: "zenwidgets_widget_default",
  default_formatter: "zenwidgets_widget_default_formatter",
)]
class WidgetItem extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    return [
      'columns' => [
        'value' => [
          'type' => 'text',
          'size' => 'tiny',
          'not null' => TRUE,
        ],
        'instance_data' => [
          'type' => 'text',
          'size' => 'big',
          'not null' => FALSE,
        ],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = [];

    $properties['value'] = DataDefinition::create('string')
      ->setLabel(t('Widget'));

    $properties['instance_data'] = DataDefinition::create('string')
      ->setLabel(t('Instance data'));

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty() {
    $value = $this->get('value')->getValue();
    return !$value;
  }

}
