<?php

namespace Drupal\zenwidgets\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

#[FieldWidget(
  id: 'zenwidgets_widget_default',
  label: new TranslatableMarkup('Widget'),
  field_types: ['zenwidgets_widget'],
)]
class WidgetDefaultWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element['value'] =
      $element + [
        '#type' => 'select',
        '#default_value' => $items[$delta]->value ?? NULL,
        '#options' => $this->getWidgetOptions(),
        '#empty_option' => $this->t('- None -'),
      ];
    return $element;
  }

  /**
   * @return array
   */
  private function getWidgetOptions(): array {
    $result = [];

    /** @var \Drupal\zenwidgets\Service\ZenWidgetsService $widgetsService */
    $widgetsService = \Drupal::service('zenwidgets');
    $availableWidgets = $widgetsService->getWidgets();
    if (!$availableWidgets) {
      return $result;
    }

    foreach ($availableWidgets as $instance) {
      $title = $instance->title ?? $this->t('- no title -');
      $result[$instance->id] = "$instance->type: $title ($instance->id)";
    }

    return $result;
  }

}
