<?php

namespace Drupal\zenwidgets\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\RedundantEditableConfigNamesTrait;

/**
 * Configuration form.
 */
class ZenWidgetsConfigForm extends ConfigFormBase {

  use RedundantEditableConfigNamesTrait;

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'zenwidgets_config';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $form['website_id'] = [
      '#title' => 'Website ID',
      '#type' => 'textfield',
      '#description' => $this->t('Go to <a href="https://www.zenwidgets.com">zenwidgets.com</a> to register for an account to get your website ID and authentication token.'),
      '#required' => TRUE,
      '#config_target' => 'zenwidgets.config:website_id',
    ];
    $form['authentication_token'] = [
      '#title' => 'Authentication token',
      '#type' => 'textfield',
      '#required' => TRUE,
      '#config_target' => 'zenwidgets.config:authentication_token',
    ];
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save'),
    ];
    return $form;
  }

}
