*ZERO POINT theme for Drupal 8, 9, 10 and 11.*
=============================================
Thank you for downloading this theme!


ABOUT THE 0 POINT THEME:
===========================

**Zero Point** is an advanced responsive, mobile first, HTML5 theme with layout 
andstyle configuration options built in that you can control through Drupal's 
UI. The theme is a highly customized and complex theme that goes beyond the 
basic customization options provided by Drupal. It uses [Yahoo Pure.css](https://purecss.io), 
a powerful responsive CSS framework and also fully supports right to left 
languages. Pure is ridiculously tiny. The entire set of modules clocks in at 
3.5KB minified and gzipped.

The theme **validates HTML5 and CSS3**, it is cross-browser compatible, and it 
complies with [WAVE](https://wave.webaim.org/) and [FAE](https://fae.cita.uiuc.edu/).


Theme's features
----------------------------------------

- 1, 2, or 3 column layout with customizable widths using [Yahoo Pure.css Framework](https://purecss.io);
- 15 block regions;
- 11 colour styles + themer setting. Choose themer style from theme's settings 
  and then make appropriate modifications of _custom/example.custom-style.css;
- **Helpful body classes** (unique classes for each page, term, website section, 
  etc.);
- Themed blocks, block icons, page icons;
- Drop-down Main menu;
- Primary/secondary links menu position (center, left, right);
- Three font families;
- Different font sizes;
- Round corners for page elements and menus;
- Header image rotator;
- Full breadcrumb;
- No-followed login/register links;
- Duplicate the Main Menu in the footer of the page.
- Possibility to **change "Submitted by" display**;
- **Advanced SEO optimization**;
- Theme's own slideshow with Multilingual support. It now features two distinct 
  variations, each comprising 7 slides: one showcasing full-page images and the 
  other displaying half-page images.
- Social links integration;
- **Bi-directional right to left (RTL) theming**;
- The possibility of having different logos depending on the language;
- Works perfect in Multilingual installations.


Advanced theme settings features
----------------------------------------

### Pure.CSS settings

- Responsive CSS files served from Yahoo CDN or locally;
- Layout with fixed or fluid width;
- Customizable width for First and Second sidebars;
- Feature to choose the blocks visible on mobile devices.


### Layout settings

- 12 color style options: Grey, Sky, Nature, Ivy, Ink, Orange, Sangue, Lime, 
  Plum, Velvet, Clean and Themer; 
- Three font families (Sans-Serif, Montserrat and Merriweather);
- Three font size settings;
- Themed blocks;
- 32x32 pixel or 48x48 pixels Block icons for the themed blocks;
- Main Drop-down menu and secondary menu can be positioned (center, left, 
  right);
- Three options for Search submit: button, icon or none;
- Page icons - choose a layout with or without page icons;
- Rounded corners for page elements and menus;
- Header image rotator;
- Duplicate the Main Menu at the bottom of the page.


### Breadcrumbs
- Display breadcrumb or not


### What author/date information to display?
- Change author and date information on all node types and/or differently for 
  Article, Basic Page, Book Page, Blog Post, and Forum Topic content types;
- Options to show the last saved date and time.
- Replace "Submitted by" with custom text.
- Customizable prefixes for the Published and Last Updated dates.


### Search engine optimization (SEO) settings
- Change "site name" heading;
- Change "block title" heading. 


### Slideshow with maximum seven slides
- Option to show on the frontpage only or on all pages;
- Half or full page image width.


### Social Media Links
- Social Media Links at the bottom of the page.


### Theme customization
- The relative path and filename of the custom CSS file;
- Site ID body class - useful in a multi-site environment;
- Show Logo per language.


### Other settings
- Remove Drupal META tag & Drupal X-Generator from header;
- Disable cache for all blocks;
- Toolbar fix: Adds additional space under the toolbar if you need so. 


To know more, read [the handbook] (https://drupal.org/node/507792).


Module support
----------------------------------------

The theme can support virtualy any module.
This versatile, **base theme** stands alone, free from dependence on other 
modules or libraries.

  
Theme customisation
----------------------------------------

If you feel like giving the theme a look of your own, I recommend to play with 
_custom/example.custom-style.css; please read the comments in this file.

Important: When updating the theme using Composer (as recommended by 
Drupal), the file example.custom-style.css will be replaced, and any 
untracked files may be deleted.

To avoid losing your customizations, follow these steps:
- Rename example.custom-style.css to something like custom-style.css.
- Move the renamed file to a safer location, such as the Drupal themes 
  folder (themes/, themes/custom/, or another appropriate directory on 
  your web server).
- Update the file path in the themes settings accordingly:
  - If custom-style.css is placed directly in the theme folder, use:
        ../../custom-style.css
  - If it's placed in themes/custom, use:
        ../custom-style.css

#### Header rotator
To change the rotating images in header you must replace the images in 
/_custom/headerimg or /_custom/headerimg-rtl with your own, naming them exactly 
like those in folder. As info, the image dimensions are 846x200 px. 
If you want to change header images rotator behaviour on mobile follow the 
instructions on the end of /_custom/example.custom-style.css.

#### Font Awesome
First, you must install [Font Awesome Icons](https://www.drupal.org/project/fontawesome) and enable 
"Font Awesome" in the theme settings.
To use Font Awesome in the Main Navigation, add the appropriate class to the 
menu title. For example, use fa fa-home for "Home" or fa fa-envelope for 
"Contact."

The Main Navigation examples provided are for reference. For a complete list of 
available Font Awesome icons, visit the [Font Awesome documentation](https://docs.fontawesome.com/).

#### Slideshow
At www.dr.mt, you'll find a compilation of pre-optimized images for your 
slideshow. Feel free to download them from this source, where the images 
are organized into sections.


Installation instructions
----------------------------------------

1. Place the zeropoint directory into your themes directory (/themes/zeropoint) 
   or use Composer. If using Composer, the theme will be installed at 
   /themes/contrib/zeropoint.
2. Enable the 0 Point theme (/admin/appearance).
3. Proceed to the theme's settings by navigating to 
   /admin/appearance/settings/zeropoint and ensure to save the configuration.
   Note that some of the theme's settings are multilingual variables, allowing 
   you to configure different settings for each language.
4. Within the themes' directory, locate the "_custom" folder and rename 
   'example.custom-style.css', for example to 'custom-style.css'. This file, 
   'custom-style.css', provides extensive customization options and may contain 
   your custom CSS and CSS overrides. Please read the information in this file 
   and follow the directions provided in the chapter above.


UPGRADING to a new version of 0 Point
----------------------------------------

1. Log in as administrator user. 
2. Put the site in "Off-line" mode.
3. Place the zeropoint directory into your themes directory (/themes/zeropoint) 
   or use Composer. In case you have done some theme customization, remember to 
   overwrite theme's custom-style.css with your modified custom-style.css file. 
4. Clear cached data at /admin/config/development/performance or "Flush all 
   caches" in Admin Menu and then press CTRL+F5;
5. Put the site in "On-line" mode. It is always a good idea to refresh the 
   browser's cache again.
6. Check the theme's settings at /admin/appearance/settings/zeropoint. 


Resources
----------------------------------------

- [Yahoo Pure.css Framework](https://purecss.io)
- [Github Project Page](https://github.com/yui/pure/)
- [Pure skin builder](https://yui.github.io/skinbuilder/?mode=pure)


Sites using "Zero Point" theme
----------------------------------------

Various implementations of the Zero Point theme can be found here:
- [Dr. Radut](https://www.radut.com/)(customized theme)
- [Smokers Association](https://www.smokersassociation.org/)(customized theme)
- [Shilma, the invisible mask!](https://www.shilma.com/)(customized theme)
- [The European Copyright Office](https://www.eucopyright.com/)
- [Phoenix](https://www.mlnar.ro/)


Related themes
----------------------------------------

- [ABC](https://www.drupal.org/project/abc) - a very customizable HTML5 theme;
- [Black Hole](https://www.drupal.org/project/black_hole) - a dark HTML5 theme.
- [Yahoo Pure.CSS Framework](https://www.drupal.org/project/pure_css) - an advanced responsive, 
  mobile-first, HTML5, base-theme;


Contact
----------------------------------------

My Drupal nick is [Florian](https://www.drupal.org/u/florian) and I can be 
reached at florian@radut.net (https://www.radut.com).

I can also be contacted for paid customizations of the theme as well as Drupal 
consulting, installation and customizations.
