/**
 * @file
 * Adds the active class to active links, for proper top bar rendering.
 *
 */
(function ($, Drupal) {
  /**
   * Adds the "active" class to top bar <li> elements with active child links.
   */
  Drupal.behaviors.foundationTopBarActive = {
    attach: function (context, settings) {
      var $active_links = $(context).find('.top-bar .menu-item > a.is-active');
      if ($active_links.length) {
        $(once('foundationTopBarActive', $active_links)).each(function() {
          $(this).parent().addClass('active');
        });
      }
    }
  };

})(jQuery, Drupal);
